# Tawk.to Live Chat Setup Guide for Hotel Noesis

## ✅ What's Been Integrated

I've integrated **Tawk.to** live chat into your Hotel Noesis website with custom styling that matches your luxury brand aesthetic. The chat widget features:

- **Gold gradient branding** matching your color scheme
- **Elegant styling** with your Cormorant Garamond font
- **Smooth animations** and micro-interactions
- **Mobile-responsive design**
- **Custom message bubbles** in champagne and gold tones

---

## 🚀 Setup Instructions (5 Minutes)

### Step 1: Create Your Free Tawk.to Account

1. Go to **[https://www.tawk.to/](https://www.tawk.to/)**
2. Click **"Sign Up Free"**
3. Enter your details:
   - **Name:** Hotel Noesis
   - **Email:** Your admin email
   - **Password:** Create a secure password
4. Complete the registration

### Step 2: Get Your Widget Code

1. After logging in, you'll be in the **Dashboard**
2. Click on **"Administration"** → **"Property Settings"**
3. Look for your **Property ID** (it looks like: `5f1234567890abcdef123456`)
4. Go to **"Widget"** section to find your **Widget ID** (also called "Default")

### Step 3: Update Your Website

Open **`index.html`** in your code editor and find this line (near the bottom):

```javascript
s1.src='https://embed.tawk.to/YOUR_PROPERTY_ID/YOUR_WIDGET_ID';
```

Replace `YOUR_PROPERTY_ID` and `YOUR_WIDGET_ID` with the IDs from Step 2.

**Example:**
```javascript
s1.src='https://embed.tawk.to/5f1234567890abcdef123456/default';
```

### Step 4: Customize Your Chat Widget

In your Tawk.to dashboard:

1. **Go to:** Administration → Chat Widget
2. **Widget Color:** Set to `#bd9a41` (your gold primary color)
3. **Widget Position:** Bottom Right (already configured)
4. **Widget Name:** "Hotel Noesis Concierge" or "Guest Services"
5. **Welcome Message:** 

   ```
   Welcome to Hotel Noesis 🌟
   
   How may we assist you today? Whether you're inquiring about reservations, dining, or our wellness facilities, we're here to help.
   ```

6. **Offline Message:** 
   ```
   We're currently away but will respond shortly. 
   
   For immediate assistance, please call +256760126602 or email reservation@hotelnoesis.com
   ```

### Step 5: Set Your Availability

1. **Go to:** Administration → Hours
2. **Set your business hours** (e.g., 7:00 AM - 11:00 PM EAT)
3. **Add team members:** Invite your reception/concierge team
4. **Enable email notifications** so you never miss a message

---

## 📱 Download Mobile Apps

To respond to guests on the go:

- **iOS:** [Download from App Store](https://apps.apple.com/app/tawk-to/id1037360951)
- **Android:** [Download from Play Store](https://play.google.com/store/apps/details?id=com.tawk.copilot)

---

## 🎨 Customization Already Applied

The following customizations are **already integrated** in your CSS:

✅ Gold gradient button matching your brand  
✅ Luxury message bubbles in champagne & gold  
✅ Smooth animations and hover effects  
✅ Mobile-responsive design  
✅ Custom form styling with your fonts  
✅ Elegant shadows and transitions  

---

## 💡 Pro Tips for Hotel Noesis

### 1. **Set Up Canned Responses**
Create quick replies for common questions:
- Room availability
- Restaurant reservations
- Spa bookings
- Check-in/check-out times
- Airport transfer information

### 2. **Monitor Peak Times**
Check when guests chat most frequently and ensure staff availability during those hours.

### 3. **Integrate with Email**
Enable email forwarding so offline messages go to reservation@hotelnoesis.com

### 4. **Use Visitor Details**
Tawk.to shows visitor location, page they're on, and browsing history - use this to personalize responses.

### 5. **Add Shortcuts**
Create keyboard shortcuts for:
- `!rooms` → Link to Stay page
- `!contact` → Contact information
- `!dining` → Dining options overview
- `!wellness` → Spa services link

---

## 🔧 Advanced Configuration

### Custom Pre-Chat Form
To collect guest information before chat starts:

1. **Go to:** Administration → Chat Widget → Pre-Chat Form
2. **Enable it** and add fields:
   - Name (required)
   - Email (required)
   - Phone (optional)
   - Inquiry Type (Dropdown: Reservations, Dining, Spa, General)

### Trigger Messages
Set up automatic messages:
- **After 10 seconds on "Stay" page:** "Planning a visit? Let us help you find the perfect room!"
- **After 20 seconds on homepage:** "Welcome to Hotel Noesis! Need assistance?"

### Knowledge Base
Create a mini FAQ that appears before chat:
- Room types and pricing
- Dining hours
- Spa services
- Location and directions

---

## 📊 Analytics & Monitoring

Tawk.to provides:
- **Real-time visitor monitoring** - See who's on your site
- **Chat history** - Review all conversations
- **Performance metrics** - Response time, satisfaction ratings
- **Team reports** - Track individual agent performance

---

## 🆘 Support

If you need help:
- **Tawk.to Support:** [https://help.tawk.to/](https://help.tawk.to/)
- **Live Chat with Tawk.to:** Available on their website
- **Documentation:** Comprehensive guides in their help center

---

## ✨ What Guests Will See

When guests visit your website, they'll see:
1. **Elegant gold chat bubble** in the bottom-right corner
2. **Subtle pulsing animation** to catch attention (optional - can be disabled)
3. **Professional welcome message** when they click
4. **Beautifully styled chat window** matching your brand
5. **Instant or queued response** depending on your availability

---

## 🎯 Next Steps

1. ✅ **Create your Tawk.to account**
2. ✅ **Get your Property ID and Widget ID**
3. ✅ **Update the code in index.html**
4. ✅ **Test the chat on your website**
5. ✅ **Download the mobile app**
6. ✅ **Set your availability hours**
7. ✅ **Train your team** on using the dashboard
8. ✅ **Monitor and respond** to guest inquiries

---

**Congratulations!** 🎉 You now have a luxury-branded live chat system that will enhance guest communication and potentially increase bookings.

For questions or adjustments to the styling, just let me know!
